// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ car.cpp ]				Auter : KENSUKE WATANABE
//												Data  : 2017/08/24
//
// -------- -------- -------- -------- -------- -------- -------- --------
#ifndef _CAR_H_
#define _CAR_H_

#include "main.h"
#include <unordered_map>

//-----------------------------------------------------------------------------
// 萔`
//-----------------------------------------------------------------------------

// O錾
class CSceneModel;

//-----------------------------------------------------------------------------
// NX
//-----------------------------------------------------------------------------
class CCar
{
public:
	CCar();
	~CCar();

	void Update(void);

	static void ReleaseAll(void);

	void MoveForward();		// Oi
	void MoveBackward();	// i
	void MoveFrictional();	// 
	void TurnRight();
	void TurnLeft(); 

	const float &GetFrictional(void)const { return m_frictional; }		// C
	const D3DXVECTOR3 &GetMove(void)const { return m_move; }			// ړ
	const D3DXVECTOR3 &GetCamPosAt(void)const { return m_camPosAt; }	// J̒_ɂė~W

	// 
	static CCar* Create(D3DXVECTOR3 pos, D3DXVECTOR3 rot, std::string onlyCarName);

	// Ԃ}bv擾
	static CCar *GetCar(std::string name) {
		if (m_umapCarManager.count(name) != 0) { return m_umapCarManager[name]; }
		return nullptr;
	}

	// 擾
	const D3DXVECTOR3 &GetPos(void)const { return m_pos; }
	const D3DXVECTOR3 &GetRot(void)const { return m_rot; }

private:

	CSceneModel *m_pBody;		// {fB
	CSceneModel *m_pTire[4];	// ^C - 0:O, 1:EO, 2:, 3:E

	D3DXVECTOR3 m_pos;			// Ԃ̈ʒu
	D3DXVECTOR3 m_move;			// Ԃ̈ړ
	D3DXVECTOR3 m_rot;			// Ԃ̉]
	float m_turn;				// ^C
	float m_moveTurn;			// ^C
	float m_frictional;			// C
	D3DXVECTOR3 m_camPosAt;		// J̒_ɂė~ʒu

	static std::unordered_map<std::string, CCar*> m_umapCarManager;
};

#endif